{-----------------------------------------------------------------------------
This Software is placed into Publlic Domain and distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied.
The Initial Developer is Martin Waldenburg
(Martin.Waldenburg@T-Online.de).
-----------------------------------------------------------------------------}
unit mwDelphiLanguageElements;

interface

uses
  SysUtils, Classes;

const
  leZero = 0;
  leSpace = 2;
  leTab = 9;
  leLF = 10;
  leCR = 13;
  leExclam = 33;
  leDoubleQuote = 34;
  leSharp = 35;
  leDollar = 36;
  lePercent = 37;
  leAmpersand = 38;
  leApostrophe = 39;
  leRoundOpen = 40;
  leRoundClose = 41;
  leAsterisk = 42;
  lePlus = 43;
  leComma = 44;
  leMinus = 45;
  lePeriod = 46;
  leSlash = 47;
  leNumber = 48;
  leColon = 58;
  leSemicolon = 59;
  leLess = 60;
  leEqual = 61;
  leGreater = 62;
  leQuestion = 63;
  leAtChar = 64;
  leSquareOpen = 91;
  leBackslash = 92;
  leSquareClose = 93;
  leAsciiCircum = 94;
  leQuoteLeft = 96;
  leCurlyOpen = 123;
  leBar = 124;
  leCurlyClose = 125;
  leAsciiTilde = 126;

  leLineEnd = 300;
  leIdentifier = leLineEnd + 1;
  leInternationalIdentifier = leIdentifier + 1;
  leUTF2Identifier = leInternationalIdentifier + 1;
  leUTF4Identifier = leUTF2Identifier + 1;
  leUTF8Identifier = leUTF4Identifier + 1;
  leUTF16Identifier = leUTF8Identifier + 1;

  leAssignment = leUTF16Identifier + 1;
  leCharConstant = leAssignment + 1;
  leCharHexConstant = leCharConstant + 1;
  leDotDot = leCharHexConstant + 1;
  leDoubleAt = leDotDot + 1;
  leFloat = leDoubleAt + 1;
  leGreaterOrEqual = leFloat + 1;
  leHexNumber = leGreaterOrEqual + 1;
  leLessOrEqual = leHexNumber + 1;
  leNotEqual = leLessOrEqual + 1;
  leStringConstant = leNotEqual + 1;
  leUnterminatedStringConstant = leStringConstant + 1;

  leAtEnd = High(Integer);
  leUnknown = leAtEnd - 1;

  leDelphiBase = 1000;
  leAnsiComment = leDelphiBase + 1;
  leAnsiDirective = leAnsiComment + 1;
  leAssemblerReference = leAnsiDirective + 1;
  leBeginOfAnsiDirective = leAssemblerReference +1;
  leBeginOfBorlandDirective = leBeginOfAnsiDirective +1;
  leBorlandComment = leBeginOfBorlandDirective + 1;
  leBorlandDirective = leBorlandComment + 1;
  leEndOfAnsiComment = leBorlandDirective + 1;
  leSkippedCode = leEndOfAnsiComment + 1;
  leSlashComment = leSkippedCode + 1;

  {KeyWords}
  leDelphiKeyWord = 1100;
  leAnd = leDelphiKeyWord + 1;
  leArray = leAnd + 1;
  leAs = leArray + 1;
  leAsm = leAs + 1;
  leBegin = leAsm + 1;
  leCase = leBegin + 1;
  leClass = leCase + 1;
  leConst = leClass + 1;
  leConstructor = leConst + 1;
  leDestructor = leConstructor + 1;
  leDispinterface = leDestructor + 1;
  leDiv = leDispinterface + 1;
  leDo = leDiv + 1;
  leDownto = leDo + 1;
  leElse = leDownto + 1;
  leEnd = leElse + 1;
  leExcept = leEnd + 1;
  leExports = leExcept + 1;
  leFile = leExports + 1;
  leFinal = leFile + 1;
  leFinalization = leFinal + 1;
  leFinally = leFinalization + 1;
  leFor = leFinally + 1;
  leFunction = leFor + 1;
  leGoto = leFunction + 1;
  leIf = leGoto + 1;
  leImplementation = leIf + 1;
  leIn = leImplementation + 1;
  leInherited = leIn + 1;
  leInitialization = leInherited + 1;
  leInline = leInitialization + 1;
  leInterface = leInline + 1;
  leIs = leInterface +1;
  leLabel = leIs + 1;
  leLibrary = leLabel + 1;
  leMod = leLibrary + 1;
  leNil = leMod + 1;
  leNot = leNil + 1;
  leObject = leNot + 1;
  leOf = leObject + 1;
  leOr = leOf + 1;
  lePacked = leOr + 1;
  leProcedure = lePacked + 1;
  leProgram = leProcedure + 1;
  leProperty = leProgram + 1;
  leRaise = leProperty + 1;
  leRecord = leRaise + 1;
  leRepeat = leRecord + 1;
  leResourcestring = leRepeat + 1;
  leSealed = leResourcestring + 1;
  leSet = leSealed + 1;
  leShl = leSet + 1;
  leShr = leShl + 1;
  leString = leShr + 1;
  leThen = leString + 1;
  leThreadvar = leThen + 1;
  leTo = leThreadvar + 1;
  leTry = leTo + 1;
  leType = leTry + 1;
  leUnit = leType + 1;
  leUntil = leUnit + 1;
  leUses = leUntil + 1;
  leVar = leUses + 1;
  leWhile = leVar + 1;
  leWith = leWhile + 1;
  leXor = leWith + 1;

  {Directives}
  leDelphiDirective = 1500;
  leAbsolute = leDelphiDirective + 1;
  leAbstract = leAbsolute + 1;
  leAssembler = leAbstract + 1;
  leAt = leAssembler + 1;
  leAutomated = leAt + 1;
  leCdecl = leAutomated + 1;
  leContains = leCdecl + 1;
  leDefault = leContains + 1;
  leDeprecated = leDefault + 1;
  leDispid = leDeprecated + 1;
  leDynamic = leDispid + 1;
  leExperimental = leDynamic + 1;
  leExport = leExperimental + 1;
  leExternal = leExport + 1;
  leFar = leExternal + 1;
  leForward = leFar + 1;
  leHelper = leForward + 1;
  leImplements = leHelper + 1;
  leIndex = leImplements + 1;
  leLocal = leIndex + 1;
  leMessage = leLocal + 1;
  leName = leMessage + 1;
  leNear = leName + 1;
  leNodefault = leNear + 1;
  leOn = leNodefault + 1;
  leOperator = leOn + 1;
  leOut = leOperator + 1;
  leOverload = leOut + 1;
  leOverride = leOverload + 1;
  lePackage = leOverride + 1;
  lePascal = lePackage + 1;
  lePlatform = lePascal + 1;
  lePrivate = lePlatform + 1;
  leProtected = lePrivate + 1;
  lePublic = leProtected + 1;
  lePublished = lePublic + 1;
  leRead = lePublished + 1;
  leReadonly = leRead + 1;
  leRegister = leReadonly + 1;
  leReintroduce = leRegister + 1;
  leRequires = leReintroduce + 1;
  leResident = leRequires + 1;
  leSafecall = leResident + 1;
  leStatic = leSafecall + 1;
  leStdcall = leStatic + 1;
  leStored = leStdcall + 1;
  leStrict = leStored + 1;
  leVarargs = leStrict + 1;
  leVirtual = leVarargs + 1;
  leWrite = leVirtual + 1;
  leWriteonly = leWrite + 1;

  {Additional}
  leDelphiAdditional = 2000;
  leA = leDelphiAdditional +1;
  leB = leA +1;
  leC = leB +1;
  leD = leC +1;
  leE = leD +1;
  leG = leE +1;
  leH = leG +1;
  leI = leH +1;
  leJ = leI +1;
  leL = leJ +1;
  leM = leL +1;
  leO = leM +1;
  leP = leO +1;
  leQ = leP +1;
  leR = leQ +1;
  leS = leR +1;
  leT = leS +1;
  leU = leT +1;
  leV = leU +1;
  leW = leV +1;
  leX = leW +1;
  leY = leX +1;
  leZ = leY +1;
  leOff = leZ +1;
  leYD = leOff +1;
  leIfDef = leYD +1;
  leGUI = leIfDef +1;
  leEndIf = leGUI +1;
  leIfEnd = leEndIf +1;
  leDefine = leIfEnd +1;
  leAlign = leDefine +1;
  leIfNDef = leAlign +1;
  leLink = leIfNDef +1;
  leDefined = leLink +1;
  leUnDef = leDefined +1;
  leDeclared = leUnDef +1;
  leElseIf = leDeclared +1;
  leImageBase = leElseIf +1;
  leIfOpt = leImageBase +1;
  leSoName = leIfOpt +1;
  leInclude = leSoName +1;
  leHints = leInclude +1;
  leNoDefine = leHints +1;
  leIOChecks = leNoDefine +1;
  leDebugInfo = leIOChecks +1;
  leConsole = leDebugInfo +1;
  leBooleval = leConsole +1;
  leHPPEmit = leBooleval +1;
  leRangeChecks = leHPPEmit +1;
  leNoInclude = leRangeChecks +1;
  leApptype = leNoInclude +1;
  leSafeDivide = leApptype +1;
  leResource = leSafeDivide +1;
  leWarn = leResource +1;   
  leWarnings = leWarn +1;
  leTypeInfo = leWarnings +1;   
  leSoPrefix = leTypeInfo +1;
  leStackFrames = leSoPrefix +1;
  leRunOnly = leStackFrames +1; 
  leSoSuffix = leRunOnly +1;
  leReferenceInfo = leSoSuffix +1;   
  leDesignOnly = leReferenceInfo +1;
  leExtension = leDesignOnly +1;
  leImportedData = leExtension +1;
  leDescription = leImportedData +1; 
  leSoVersion = leDescription +1;
  leAssertions = leSoVersion +1;  
  leImplicitBuild = leAssertions +1;  
  leTypedAddress = leImplicitBuild +1;
  leLocalSymbols = leTypedAddress +1; 
  leMinEnumSize = leLocalSymbols +1; 
  leWeakPackageUnit = leMinEnumSize +1;
  leDefinitionInfo = leWeakPackageUnit +1;  
  leMinStackSize = leDefinitionInfo +1;   
  leObjExportAll = leMinStackSize +1;
  leMaxStackSize = leObjExportAll +1; 
  leLongStrings = leMaxStackSize +1; 
  leDenyPackageUnit = leLongStrings +1;
  leExternalSym = leDenyPackageUnit +1;  
  leOpenStrings = leExternalSym +1;
  leOverFlowChecks = leOpenStrings +1;
  leWriteableConst = leOverFlowChecks +1;   
  leOptimization = leWriteableConst +1;
  leVarStringChecks = leOptimization +1;
  leExtendedSyntax = leVarStringChecks +1;
  leRealCompatibility = leExtendedSyntax +1;
  leResourceReserve = leRealCompatibility +1;
  leAndDirective = leResourceReserve +1;
  leElseDirective = leAndDirective +1;
  leIfDirective = leElseDirective +1;
  leOnDirective = leIfDirective +1;
  leOrDirective = leOnDirective +1;
  leRegion = leOrDirective +1;
  leEndRegion = leRegion +1;
  leStackChecks = leEndRegion +1;
  leSymbol_Platform = leStackChecks +1;
  leSymbol_Library = leSymbol_Platform +1;
  leSymbol_Deprecated = leSymbol_Library +1;
  leUnit_Deprecated = leSymbol_Deprecated +1;
  leUnit_Library = leUnit_Deprecated +1;
  leUnit_Platform = leUnit_Library +1;
  leUnknownDirective = leUnit_Platform +1;
implementation

end.

